//*************************************************************************************************
//
//	Description:
//		basic2D.fx - simple 2D shader ( lifted from GUI.fx )
//		2D vertex input used for texcoords, and transformed by position_xform to give screen position in 0-1 range
//
//	<P> Copyright (c) 2007 Blimey! Games Ltd. All rights reserved.
//
//	Author: 
//		Alan Savage
//		TNettleship			10/23/2007	0.2					Converted to on-load rendermode behaviour binding.

//
// Textures
//

#include "stddefs.fxh"

texture DiffuseTexture : TEXTURE < bool appEdit = true; >;

float4x4	position_xform < bool appEdit = true; >;
float4		rgba_modifier < bool appEdit = true; >;
//bool		has_texture < bool appEdit = true; >;

//-----------------------------------------------------------------------
//
// Samplers
//

sampler2D DiffuseMap : SAMPLER 
< 
	SET_SRGB_TEXTURE
	bool appEdit = false; 
	string SamplerTexture="DiffuseTexture"; 
	string MinFilter = "Linear";
	string MagFilter = "Linear";
	string MipFilter = "None";
	string AddressU  = "Clamp";
	string AddressV  = "Clamp";
	int MipMapLODBias = 0;
> 
= sampler_state
{
	Texture = < DiffuseTexture >;
#if defined(SET_FX_SAMPLER_STATES)
	FX_SAMPLERSTATE_SRGB_TEXTURE
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = None;
	AddressU = Clamp;
	AddressV = Clamp;
#endif
};


//-----------------------------------------------------------------------
//
// Vertex Shader(s)
//

// Input structure
struct VSINPUT
{
	float2 position : POSITION;
};


// Output structure (also input to the fragment shader)
struct VSOUTPUT
{
	float4 position		: POSITION;													// View-coords position
	float2 texCoord		: TEXCOORD0;												// UV coords for texture channel 0
};


//-----------------------------------------------------------------------
//
// Vertex shader code
//

VSOUTPUT BasicVertexShader( VSINPUT _input )
{
	VSOUTPUT _output = ( VSOUTPUT )0;

	_output.texCoord = _input.position.xy;
	
	float4	pos4 = float4( _input.position.xy, 0.0f, 1.0f );
	_output.position.xy = mul( position_xform, pos4 );
	_output.position.xy = (_output.position.xy*2.0f)-1.0f;	// DX has output coords between -1 and 1
	_output.position.y *= -1.0f;				// and y is inverted

	_output.position.z = 0.0f;
	_output.position.w = 1.0f;

	return _output;
}
			


//-----------------------------------------------------------------------
//
// Fragment Shader(s)
//

// Output structure
struct PSOUTPUT
{
	COLOUR_OUTPUT_TYPE Colour : COLOR0;
};



//-----------------------------------------------------------------------
//
// Fragment shader code
//

PSOUTPUT BasicFragmentShader( VSOUTPUT _input )
{
	PSOUTPUT _output = ( PSOUTPUT )0;

	// Read textures
	float2	uv = _input.texCoord;
	float4	Colour;
  	Colour = tex2D( DiffuseMap, uv );
	_output.Colour = CalculateOutputPixel( Colour*rgba_modifier );

	return _output;
}

PSOUTPUT BasicAlphaConstantFragmentShader( VSOUTPUT _input )
{
	PSOUTPUT _output = ( PSOUTPUT )0;

	// Read textures
	float2	uv = _input.texCoord;
	float4	Colour;
  Colour = tex2D( DiffuseMap, uv );
	Colour.rgb *= rgba_modifier;
	Colour.a = rgba_modifier.a;
	_output.Colour = CalculateOutputPixel( Colour );

	return _output;
}

PSOUTPUT AlphaFragmentShader( VSOUTPUT _input )
{
	PSOUTPUT _output = ( PSOUTPUT )0;

	// Read textures
	float2	uv = _input.texCoord;
	float4	Colour;
  	Colour = tex2D( DiffuseMap, uv );
	Colour = Colour*rgba_modifier;
	Colour*=Colour.a;
	_output.Colour = CalculateOutputPixel( Colour );

	return _output;
}

//-----------------------------------------------------------------------
//
// Technique(s)
//

technique Basic
<
	string normalBehaviour	= "ERMB_RENDER";
	string normalTechnique	= "Basic";
	int    normalDeferredID	= 0;
>
{
	pass Pass0
	{
		ZEnable = false;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
#ifdef _PS3_
		BlendFunc=int2(SrcAlpha, OneMinusSrcAlpha);
		BlendEquation=int(FuncAdd);
		VertexShader = compile sce_vp_rsx BasicVertexShader();
		PixelShader = compile sce_fp_rsx BasicFragmentShader();
#else		
#if defined(_XBOX360_)
		DestBlend = INVSRCALPHA;
		SrcBlend = SRCALPHA;
		BlendOp = ADD;
		VertexShader = compile vs_3_0 BasicVertexShader();
		PixelShader = compile ps_3_0 BasicFragmentShader();
#else		
		DestBlend = INVSRCALPHA;
		SrcBlend = SRCALPHA;
		BlendOp = ADD;
		VertexShader = compile vs_1_1 BasicVertexShader();
		PixelShader = compile ps_2_0 BasicFragmentShader();
#endif
#endif
	}
}

technique BasicAdd
<
	string normalBehaviour	= "ERMB_RENDER";
	string normalTechnique	= "BasicAdd";
	int    normalDeferredID	= 0;
>
{
	pass Pass0
	{
		ZEnable = false;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
#ifdef _PS3_
		BlendFunc=int2(SrcAlpha, One);
		BlendEquation=int(FuncAdd);
		VertexShader = compile sce_vp_rsx BasicVertexShader();
		PixelShader = compile sce_fp_rsx BasicFragmentShader();
#else		
#if defined(_XBOX360_)
		DestBlend = ONE;
		SrcBlend = SRCALPHA;
		BlendOp = ADD;
		VertexShader = compile vs_3_0 BasicVertexShader();
		PixelShader = compile ps_3_0 BasicFragmentShader();
#else		
		DestBlend = ONE;
		SrcBlend = SRCALPHA;
		BlendOp = ADD;
		VertexShader = compile vs_1_1 BasicVertexShader();
		PixelShader = compile ps_2_0 BasicFragmentShader();
#endif
#endif
	}
}

// This is for PS3 HDR but may have other uses
#ifdef _PS3_
technique BasicAlphaAdd
<
	string normalBehaviour	= "ERMB_RENDER";
	string normalTechnique	= "BasicAlphaAdd";
	int    normalDeferredID	= 0;
>
{
	pass Pass0
	{
		ZEnable = false;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
		BlendFunc=int2(One, One);
		BlendEquation=int(FuncAdd);
		VertexShader = compile sce_vp_rsx BasicVertexShader();
		PixelShader = compile sce_fp_rsx AlphaFragmentShader();
	}
}
#endif

technique BasicAlphaConstant
<
	string normalBehaviour	= "ERMB_RENDER";
	string normalTechnique	= "BasicAlphaConstant";
	int    normalDeferredID	= 0;
>
{
	pass Pass0
	{
		ZEnable = false;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
#ifdef _PS3_
		BlendFunc=int2(SrcAlpha, OneMinusSrcAlpha);
		BlendEquation=int(FuncAdd);
		VertexShader = compile sce_vp_rsx BasicVertexShader();
		PixelShader = compile sce_fp_rsx BasicAlphaConstantFragmentShader();
#else		
#if defined(_XBOX360_)
		DestBlend = INVSRCALPHA;
		SrcBlend = SRCALPHA;
		BlendOp = ADD;
		VertexShader = compile vs_3_0 BasicVertexShader();
		PixelShader = compile ps_3_0 BasicAlphaConstantFragmentShader();
#else		
		DestBlend = INVSRCALPHA;
		SrcBlend = SRCALPHA;
		BlendOp = ADD;
		VertexShader = compile vs_1_1 BasicVertexShader();
		PixelShader = compile ps_2_0 BasicAlphaConstantFragmentShader();
#endif
#endif
	}
}
